 <?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
* @filesource
*/

/**
* @package direct-as-a-service
* @subpackage models
*/
class UserActivitySummaryModel extends CI_Model {
   
    /*
     * get the first load facilities
     */
	
	function get_first_user_activities($size)//get response when no filters for first page
	{
    	//return $this->db->query("SELECT * FROM (SELECT F.id, F.[Name], M.[is_active], U.[user_ext_mail],  M.[name] as Username, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(sum(ms.seen), 0) AS Number_of_seen, ISNULL((sum(ms.seen) + sum(ms.sent)), 0) as Total_messages, ROW_NUMBER() over (ORDER BY LOWER(F.[name]) ASC) as row FROM [mail].[dbo].[mailboxes] M LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id left join [api].[dbo].[users] U ON U.username = M.name left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id where  M.is_group != 1 AND 0=0 AND (F.id like '%' OR F.id IS NULL) GROUP BY F.id, F.name, F.id, M.[name], M.[is_active], user_ext_mail, user_ext_mail) A WHERE row >= 1 and row <= " . $size);

    	return $this->db->query("SELECT * FROM (SELECT F.id, F.[Name], M.[name] as Username, U.[user_ext_mail], M. " .
								 "[is_active], ISNULL(COUNT(DISTINCT M.id), 0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, " .
								 "ISNULL(sum(ms.seen), 0) AS Number_of_seen, COUNT(ms.id) as Total_messages, " .
								 "ROW_NUMBER() over (ORDER BY F.name DESC) as row FROM [mail].[dbo].[mailboxes] M " . 
								 "LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id " . 
								 "left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id " .
								 "left join [api].[dbo].[users] U ON U.username = M.name " . 
								 "where M.is_group != 1 AND (ms.draft = 0 OR ms.draft IS NULL) GROUP BY M.name, F.name, F.id, M.is_active, user_ext_mail) A WHERE row >= 1 and row <= " . $size);
	}
	
	function get_ldap_request($userName)//get response when no filters for first page
	{
		$ldap_conn = $this->prepare_ldap_conn();
		$ldap_bind = ldap_bind($ldap_conn, LDAP_ANON_SEARCH_USERNAME, LDAP_ANON_SEARCH_PASSWORD);
		if($ldap_bind) {
			$base_dn = LDAP_ACCOUNT_GROUP;
			$fields = array('uid','givenname','sn','mail','uidnumber','homedirectory');
			$search = @ldap_search($ldap_conn, $base_dn, '(&(uid='.$userName.'))', $fields);
			
			if($search){ $entries = ldap_get_entries($ldap_conn, $search); }
			else{ $entries = array('count' => 0); }
	
			return $entries;
		}
	}
	
	/*
     * get the list of facilities reports
     */
	 
	public function get_first_user_activities_list_size()//get size of entire for reports
	{
		//return $this->db->query('SELECT count(id) as count FROM [mail].[dbo].[mailboxes] WHERE is_group != 1');
		return $this->db->query("SELECT COUNT(ms.id) as count " .
								 "FROM [mail].[dbo].[mailboxes] M " . 
								 "LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id " . 
								 "left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id " .
								 "left join [api].[dbo].[users] U ON U.username = M.name " . 
								 "where M.is_group != 1 AND (ms.draft = 0 OR ms.draft IS NULL) GROUP BY M.name, F.name, F.id, M.is_active, user_ext_mail");

	}
	
	/*
     * get the list of facilities and where 
     */
	 
	public function get_user_list_size($sql)//get size of entire for reports
	{
		return $this->db->query('SELECT count(*) count FROM (SELECT F.id as FacilityId, M.[name] as Username ' .
								'FROM [mail].[dbo].[mailboxes] M LEFT OUTER '.
								'JOIN [api].[dbo].[facility] F ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON ' .
								'MS.mailbox_id = M.id left join [api].[dbo].[users] U ON U.username = M.name  ' . 
								'where ' . $sql . 
								'AND M.is_group != 1 AND (MS.draft = 0 OR MS.draft IS NULL) GROUP BY M.name, F.name, F.id, M.is_active, user_ext_mail) A');
	}
	
	/*
     * get the list of facilities and different orders
     */
	
	function get_request_filter_facility_order($sql,$order,$start,$size)//get response with filters
	{
		if ($order == 'facilityName DESC,id DESC' || $order == 'facilityName DESC,id DESC'){
			$order = 'DESC';
		}
		else{
			$order = 'ASC';
		}
		$sql= str_replace("(id","(F.id",$sql);//needed because both tables have the same column name
		return $this->db->query('SELECt * FROM (SELECT F.id, F.[Name], user_ext_mail, M.[Name] as Username, M.[is_active], COUNT(DISTINCT M.id) as Number_of_users, sum(ms.sent) AS Number_of_sent, sum(ms.seen) AS Number_of_seen,   (sum(ms.seen) + sum(ms.sent)) as Total_messages, ROW_NUMBER() over (ORDER BY LOWER(F.[name]) '.$order.') as row   FROM [mail].[dbo].[mailboxes] M LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id left join [api].[dbo].[users] U ON U.username = M.name left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id where '.$sql.' GROUP BY M.name, F.name, F.id, M.is_active, user_ext_mail) A   WHERE row >= '.$this->db->escape($start).' and row < '.$this->db->escape($size+$start));	
	}
	
	/*
     * get the list of facilities export
     */
	
	function get_request_filter_user_activities_export($sql,$order,$start,$size)//get response with filters
	{
			//Name
		if ($order == 'facilityName DESC,id DESC'  || $order == 'facilityName DESC,id DESC' ){
			$order = '(ORDER BY F.name DESC';
		}
		if ($order == 'facilityName ASC,id ASC'  || $order == 'facilityName ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		//Seen
		if ($order == 'userNumber_of_seen DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.seen) DESC';
		}
		if ($order == 'userNumber_of_seen ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.seen) ASC';
		}
		
		//Sent
		if ($order == 'userNumber_of_sent DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.sent) DESC';
		}
		if ($order == 'userNumber_of_sent ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.sent) ASC';
		}
		
		//emailaddress
		if ($order == 'user_ext_mail DESC,id DESC' ){
			$order = '(ORDER BY user_ext_mail DESC';
		}
		if ($order == 'user_ext_mail ASC,id ASC' ){
			$order = '(ORDER BY user_ext_mail ASC';
		}
		
		//Total
		if ($order == 'userTotal_of_messages DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.id) DESC';
		}
		if ($order == 'userTotal_of_messages ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.id) ASC';
		}
		//LDAP Ordering
		
		if ($order == 'userSN DESC,id DESC' OR $order == 'userSN ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'userGivenname DESC,id DESC' OR $order == 'userGivenname ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'username DESC,id DESC' OR $order == 'username ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'userMail DESC,id DESC' OR $order == 'userMail ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'userStatus DESC,id DESC' OR $order == 'userStatus ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		if ($order == 'emailaddress DESC,id DESC' OR $order == 'emailaddress ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		$sql= str_replace("(id","(F.id",$sql);//needed because both tables have the same column name
		//return $this->db->query('SELECT * FROM (SELECT F.id, F.[Name], M.[name] as Username,  U.[user_ext_mail], M.[is_active], ISNULL(COUNT(DISTINCT M.id), 0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(sum(ms.seen), 0) AS Number_of_seen, ISNULL((sum(ms.seen) + sum(ms.sent)), 0) as Total_messages, ROW_NUMBER() over '.$order.') as row FROM [mail].[dbo].[mailboxes] M LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id left join [api].[dbo].[users] U ON U.username = M.name where '.$sql.' and  M.is_group != 1 GROUP BY  M.name, F.name, F.id, M.is_active, user_ext_mail) A ');
		return $this->db->query('SELECT * FROM (SELECT F.id, F.[Name], M.[name] as Username, U.[user_ext_mail],  M.[is_active], ISNULL(COUNT(DISTINCT M.id), 0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(COUNT(ms.id), 0) - ISNULL(sum(ms.sent), 0)AS Number_of_seen, COUNT(ms.id) as Total_messages, ROW_NUMBER() over '.$order.') as row FROM [mail].[dbo].[mailboxes] M LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id left join [api].[dbo].[users] U ON U.username = M.name where '.$sql.' and  M.is_group != 1 AND (ms.draft = 0 OR ms.draft IS NULL) GROUP BY  M.name, F.name, F.id, M.is_active, user_ext_mail) A  ');
	}
	
	/*
     * get the list of facilities
     */
	function get_request_filter_user_activities($sql,$order,$start,$size)
	{
		//Name
		if ($order == 'facilityName DESC,id DESC'  || $order == 'facilityName DESC,id DESC' ){
			$order = '(ORDER BY F.name DESC';
		}
		if ($order == 'facilityName ASC,id ASC'  || $order == 'facilityName ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		//Seen
		if ($order == 'userNumber_of_seen DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.seen) DESC';
		}
		if ($order == 'userNumber_of_seen ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.seen) ASC';
		}
		//emailaddress
		if ($order == 'user_ext_mail DESC,id DESC' ){
			$order = '(ORDER BY user_ext_mail DESC';
		}
		if ($order == 'user_ext_mail ASC,id ASC' ){
			$order = '(ORDER BY user_ext_mail ASC';
		}
		//Sent
		if ($order == 'userNumber_of_sent DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.sent) DESC';
		}
		if ($order == 'userNumber_of_sent ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.sent) ASC';
		}
		//Total
		if ($order == 'userTotal_of_messages DESC,id DESC' ){
			$order = '(ORDER BY sum(ms.id) DESC';
		}
		if ($order == 'userTotal_of_messages ASC,id ASC' ){
			$order = '(ORDER BY sum(ms.id) ASC';
		}
		//LDAP Ordering
		
		if ($order == 'userSN DESC,id DESC' OR $order == 'userSN ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'userGivenname DESC,id DESC' OR $order == 'userGivenname ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'username DESC,id DESC' OR $order == 'username ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'userMail DESC,id DESC' OR $order == 'userMail ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		
		if ($order == 'userStatus DESC,id DESC' OR $order == 'userStatus ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		if ($order == 'emailaddress DESC,id DESC' OR $order == 'emailaddress ASC,id ASC' ){
			$order = '(ORDER BY F.name ASC';
		}
		//return $this->db->query('SELECT * FROM (SELECT F.id, F.[Name], M.[name] as Username, U.[user_ext_mail],  M.[is_active], ISNULL(COUNT(DISTINCT M.id), 0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(sum(ms.seen), 0) AS Number_of_seen, ISNULL((sum(ms.seen) + sum(ms.sent)), 0) as Total_messages, ROW_NUMBER() over '.$order.') as row FROM [mail].[dbo].[mailboxes] M LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id left join [api].[dbo].[users] U ON U.username = M.name where '.$sql.' and  M.is_group != 1 GROUP BY  M.name, F.name, F.id, M.is_active, user_ext_mail) A   WHERE row >= '.$this->db->escape($start).' and row < '.$this->db->escape($size+$start));
		return $this->db->query('SELECT * FROM (SELECT F.id, F.[Name], M.[name] as Username, U.[user_ext_mail],  M.[is_active], ISNULL(COUNT(DISTINCT M.id), 0) as Number_of_users, ISNULL(sum(ms.sent), 0) AS Number_of_sent, ISNULL(COUNT(ms.id), 0) - ISNULL(sum(ms.sent), 0)AS Number_of_seen, COUNT(ms.id) as Total_messages, ROW_NUMBER() over '.$order.') as row FROM [mail].[dbo].[mailboxes] M LEFT OUTER JOIN [api].[dbo].[facility] F ON F.id = M.facility_id left join [mail].[dbo].[messages] MS ON MS.mailbox_id = M.id left join [api].[dbo].[users] U ON U.username = M.name where '.$sql.' and  M.is_group != 1 AND (ms.draft = 0 OR ms.draft IS NULL) GROUP BY  M.name, F.name, F.id, M.is_active, user_ext_mail) A  ');
		
	}
 	
	/* -----------------------------*
	 *  PRIVATE FUNCTIONS           *
	 * -----------------------------*/
	 
	/* This function prepares a connection to LDAP using the configured constants for the facility
	  * and the LDAP options required for the connection. Returns FALSE on failure, LDAP connection resource
	  * on success.
	  */
	 private function prepare_ldap_conn() {
		$ldap_conn = ldap_connect(LDAP_HOSTNAME, LDAP_PORT);
		if(!ldap_set_option($ldap_conn, LDAP_OPT_PROTOCOL_VERSION, 3)) { return FALSE; } 
		if(!ldap_set_option($ldap_conn, LDAP_OPT_REFERRALS, 0)) { return FALSE; }
		return $ldap_conn;
	}
}
